#region Using declarations
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Input;
using System.Windows.Media;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Gui;
using NinjaTrader.Gui.Chart;
using NinjaTrader.Gui.SuperDom;
using NinjaTrader.Gui.Tools;
using NinjaTrader.Data;
using NinjaTrader.NinjaScript;
using NinjaTrader.Core.FloatingPoint;

#endregion



#region NinjaScript generated code. Neither change nor remove.

namespace NinjaTrader.NinjaScript.Indicators
{
	public partial class Indicator : NinjaTrader.Gui.NinjaScript.IndicatorRenderBase
	{
		
		private WideRangeBar[] cacheWideRangeBar;

		
		public WideRangeBar WideRangeBar(int boxColorOpacity, bool showWRBDiamond, bool alertOnGapCreated, bool alertOnGapFilled, int secondsToReArm, float boxOutlineSize, bool lockGap, bool showZones)
		{
			return WideRangeBar(Input, boxColorOpacity, showWRBDiamond, alertOnGapCreated, alertOnGapFilled, secondsToReArm, boxOutlineSize, lockGap, showZones);
		}


		
		public WideRangeBar WideRangeBar(ISeries<double> input, int boxColorOpacity, bool showWRBDiamond, bool alertOnGapCreated, bool alertOnGapFilled, int secondsToReArm, float boxOutlineSize, bool lockGap, bool showZones)
		{
			if (cacheWideRangeBar != null)
				for (int idx = 0; idx < cacheWideRangeBar.Length; idx++)
					if (cacheWideRangeBar[idx].BoxColorOpacity == boxColorOpacity && cacheWideRangeBar[idx].ShowWRBDiamond == showWRBDiamond && cacheWideRangeBar[idx].AlertOnGapCreated == alertOnGapCreated && cacheWideRangeBar[idx].AlertOnGapFilled == alertOnGapFilled && cacheWideRangeBar[idx].SecondsToReArm == secondsToReArm && cacheWideRangeBar[idx].BoxOutlineSize == boxOutlineSize && cacheWideRangeBar[idx].LockGap == lockGap && cacheWideRangeBar[idx].ShowZones == showZones && cacheWideRangeBar[idx].EqualsInput(input))
						return cacheWideRangeBar[idx];
			return CacheIndicator<WideRangeBar>(new WideRangeBar(){ BoxColorOpacity = boxColorOpacity, ShowWRBDiamond = showWRBDiamond, AlertOnGapCreated = alertOnGapCreated, AlertOnGapFilled = alertOnGapFilled, SecondsToReArm = secondsToReArm, BoxOutlineSize = boxOutlineSize, LockGap = lockGap, ShowZones = showZones }, input, ref cacheWideRangeBar);
		}

	}
}

namespace NinjaTrader.NinjaScript.MarketAnalyzerColumns
{
	public partial class MarketAnalyzerColumn : MarketAnalyzerColumnBase
	{
		
		public Indicators.WideRangeBar WideRangeBar(int boxColorOpacity, bool showWRBDiamond, bool alertOnGapCreated, bool alertOnGapFilled, int secondsToReArm, float boxOutlineSize, bool lockGap, bool showZones)
		{
			return indicator.WideRangeBar(Input, boxColorOpacity, showWRBDiamond, alertOnGapCreated, alertOnGapFilled, secondsToReArm, boxOutlineSize, lockGap, showZones);
		}


		
		public Indicators.WideRangeBar WideRangeBar(ISeries<double> input , int boxColorOpacity, bool showWRBDiamond, bool alertOnGapCreated, bool alertOnGapFilled, int secondsToReArm, float boxOutlineSize, bool lockGap, bool showZones)
		{
			return indicator.WideRangeBar(input, boxColorOpacity, showWRBDiamond, alertOnGapCreated, alertOnGapFilled, secondsToReArm, boxOutlineSize, lockGap, showZones);
		}
	
	}
}

namespace NinjaTrader.NinjaScript.Strategies
{
	public partial class Strategy : NinjaTrader.Gui.NinjaScript.StrategyRenderBase
	{
		
		public Indicators.WideRangeBar WideRangeBar(int boxColorOpacity, bool showWRBDiamond, bool alertOnGapCreated, bool alertOnGapFilled, int secondsToReArm, float boxOutlineSize, bool lockGap, bool showZones)
		{
			return indicator.WideRangeBar(Input, boxColorOpacity, showWRBDiamond, alertOnGapCreated, alertOnGapFilled, secondsToReArm, boxOutlineSize, lockGap, showZones);
		}


		
		public Indicators.WideRangeBar WideRangeBar(ISeries<double> input , int boxColorOpacity, bool showWRBDiamond, bool alertOnGapCreated, bool alertOnGapFilled, int secondsToReArm, float boxOutlineSize, bool lockGap, bool showZones)
		{
			return indicator.WideRangeBar(input, boxColorOpacity, showWRBDiamond, alertOnGapCreated, alertOnGapFilled, secondsToReArm, boxOutlineSize, lockGap, showZones);
		}

	}
}

#endregion
