/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Scanner;
import main.Constants;
import main.DownloadToString;
import main.GUIFrame;
import main.ParseStringAndSave;

public class Main {
    private static final int FOREX_FACTORY_FIRST_YEAR_2007 = 2007;
    private static final SimpleDateFormat sdf = new SimpleDateFormat("dd MMM yyyy", Locale.ENGLISH);
    private static int progressCounter = 0;
    private static GregorianCalendar yesterday;
    private static int monthOfYesterday;
    private static int yearOfMonthBeforeYesterday;
    private static int monthBeforeYesterday;
    private static int yearOfYesterday;
    private static int dayOfYesterday;
    private static int yearOfLastDate;
    private static int monthOfLastDate;
    private static int dayOfLastDate;
    private static int numberOfMonthsOfHistoricalDataToDownload;

    private static int step1_nbMonthsToDownloadForFutureEconomicEvents() {
        return 2;
    }

    private static int step2_nbMonthsToDownloadForHistoricalEconomicEvents(GUIFrame frame) throws FileNotFoundException {
        yesterday = new GregorianCalendar();
        yesterday.add(5, -1);
        yearOfYesterday = yesterday.get(1);
        monthOfYesterday = yesterday.get(2) + 1;
        dayOfYesterday = yesterday.get(5);
        if (!Constants.HISTORICAL_ECONOMIC_EVENTS_OUTPUT_FILE.exists()) {
            monthBeforeYesterday = monthOfYesterday - 1;
            yearOfMonthBeforeYesterday = yearOfYesterday;
            if (monthBeforeYesterday == 0) {
                monthBeforeYesterday = 12;
                yearOfMonthBeforeYesterday = yearOfYesterday - 1;
            }
            frame.printlnInHistoricalEconomicEventsTextArea("File HistoricalEconomicEvents.txt does not exist, perhaps because this is the first time that you run this application.");
            numberOfMonthsOfHistoricalDataToDownload = (yearOfMonthBeforeYesterday - 2007) * 12 + monthBeforeYesterday + 1;
            frame.printlnInHistoricalEconomicEventsTextArea(numberOfMonthsOfHistoricalDataToDownload + " months of economic events shall be downloaded, parsed and stored.");
            return numberOfMonthsOfHistoricalDataToDownload;
        }
        frame.printlnInHistoricalEconomicEventsTextArea("File HistoricalEconomicEvents.txt already exists.");
        Scanner scanner = new Scanner(Constants.HISTORICAL_ECONOMIC_EVENTS_OUTPUT_FILE);
        String lastLine = "";
        while (scanner.hasNextLine()) {
            lastLine = scanner.nextLine();
        }
        scanner.close();
        String lastDateAsString = lastLine.substring(0, 7);
        yearOfLastDate = Integer.parseInt(lastDateAsString.substring(0, 3)) + 1900;
        monthOfLastDate = Integer.parseInt(lastDateAsString.substring(3, 5));
        dayOfLastDate = Integer.parseInt(lastDateAsString.substring(5, 7));
        GregorianCalendar lastDate = new GregorianCalendar(yearOfLastDate, monthOfLastDate - 1, dayOfLastDate);
        frame.printlnInHistoricalEconomicEventsTextArea("Date of the last event of the file is: " + sdf.format(lastDate.getTime()));
        if (lastDate.get(1) == yesterday.get(1) && lastDate.get(2) == yesterday.get(2) && lastDate.get(5) == yesterday.get(5)) {
            frame.printlnInHistoricalEconomicEventsTextArea("This date is the date of yesterday. The file is up to date.");
            numberOfMonthsOfHistoricalDataToDownload = 0;
        } else {
            numberOfMonthsOfHistoricalDataToDownload = (yearOfYesterday - yearOfLastDate) * 12 + (monthOfYesterday - monthOfLastDate) + 1;
        }
        return numberOfMonthsOfHistoricalDataToDownload;
    }

    private static void step3_proceedForFutureEconomicEvents(GUIFrame frame) throws IOException, Exception {
        frame.setFutureEconomicEventsResultLabelToProcessing();
        GregorianCalendar gc = new GregorianCalendar();
        int currentMonth = gc.get(2) + 1;
        int yearOfCurrentMonth = gc.get(1);
        int nextMonth = currentMonth + 1;
        int yearOfNextMonth = yearOfCurrentMonth;
        if (nextMonth == 13) {
            nextMonth = 1;
            ++yearOfNextMonth;
        }
        FileWriter futureEconomicEventsCsvFileWriter = new FileWriter(Constants.FUTURE_ECONOMIC_EVENTS_OUTPUT_FILE);
        frame.printlnInFutureEconomicEventsTextArea("[1/2] Download, parse and store Forex Factory economic events for the current month (" + currentMonth + "/" + yearOfCurrentMonth + ")...");
        String currentMonthWebPage = DownloadToString.downloadOneMonthToString(yearOfCurrentMonth, currentMonth);
        ParseStringAndSave.parseStringAndSaveToFile(currentMonthWebPage, futureEconomicEventsCsvFileWriter, yearOfCurrentMonth, currentMonth, 1, 31);
        frame.setProgressBarValue(++progressCounter);
        frame.printlnInFutureEconomicEventsTextArea("[2/2] Download, parse and store Forex Factory economic events for next month (" + nextMonth + "/" + yearOfNextMonth + ")...");
        String nextMonthWebPage = DownloadToString.downloadOneMonthToString(yearOfNextMonth, nextMonth);
        ParseStringAndSave.parseStringAndSaveToFile(nextMonthWebPage, futureEconomicEventsCsvFileWriter, yearOfNextMonth, nextMonth, 1, 31);
        frame.setProgressBarValue(++progressCounter);
        futureEconomicEventsCsvFileWriter.close();
        frame.printlnInFutureEconomicEventsTextArea("");
        frame.printlnInFutureEconomicEventsTextArea("Economic events for current and next months are now stored in the following CSV file located near the present executable:");
        frame.printlnInFutureEconomicEventsTextArea("   Name: FutureEconomicEvents.txt");
        String directory = Constants.FUTURE_ECONOMIC_EVENTS_OUTPUT_FILE.getAbsolutePath();
        directory = directory.substring(0, directory.length() - "FutureEconomicEvents.txt".length());
        frame.printlnInFutureEconomicEventsTextArea("   Directory: " + directory);
    }

    private static void step4_proceedForHistoricalEconomicEvents(GUIFrame frame) throws IOException, Exception {
        frame.setHistoricalEconomicEventsResultLabelToProcessing();
        if (!Constants.HISTORICAL_ECONOMIC_EVENTS_OUTPUT_FILE.exists()) {
            String webPage;
            FileWriter historicalEconomicEventsCsvFileWriter = new FileWriter(Constants.HISTORICAL_ECONOMIC_EVENTS_OUTPUT_FILE);
            int counter = 0;
            for (int year = 2007; year <= yearOfMonthBeforeYesterday - 1; ++year) {
                for (int month = 1; month <= 12; ++month) {
                    frame.printlnInHistoricalEconomicEventsTextArea("[" + ++counter + "/" + numberOfMonthsOfHistoricalDataToDownload + "] Download, parse and store Forex Factory economic events for the month " + month + "/" + year + "...");
                    webPage = DownloadToString.downloadOneMonthToString(year, month);
                    ParseStringAndSave.parseStringAndSaveToFile(webPage, historicalEconomicEventsCsvFileWriter, year, month, 1, 31);
                    frame.setProgressBarValue(++progressCounter);
                }
            }
            for (int month = 1; month <= monthBeforeYesterday; ++month) {
                frame.printlnInHistoricalEconomicEventsTextArea("[" + ++counter + "/" + numberOfMonthsOfHistoricalDataToDownload + "] Download, parse and store Forex Factory economic events for the month " + month + "/" + yearOfMonthBeforeYesterday + "...");
                webPage = DownloadToString.downloadOneMonthToString(yearOfMonthBeforeYesterday, month);
                ParseStringAndSave.parseStringAndSaveToFile(webPage, historicalEconomicEventsCsvFileWriter, yearOfMonthBeforeYesterday, month, 1, 31);
                frame.setProgressBarValue(++progressCounter);
            }
            frame.printlnInHistoricalEconomicEventsTextArea("[" + ++counter + "/" + numberOfMonthsOfHistoricalDataToDownload + "] Download, parse and store Forex Factory economic events for the month " + monthOfYesterday + "/" + yearOfYesterday + "...");
            webPage = DownloadToString.downloadOneMonthToString(yearOfYesterday, monthOfYesterday);
            ParseStringAndSave.parseStringAndSaveToFile(webPage, historicalEconomicEventsCsvFileWriter, yearOfYesterday, monthOfYesterday, 1, dayOfYesterday);
            frame.setProgressBarValue(++progressCounter);
            historicalEconomicEventsCsvFileWriter.close();
            frame.printlnInHistoricalEconomicEventsTextArea("");
            frame.printlnInHistoricalEconomicEventsTextArea("Historical economic events are now stored in the following CSV file located near the present executable:");
            frame.printlnInHistoricalEconomicEventsTextArea("   Name: HistoricalEconomicEvents.txt");
            String directory = Constants.HISTORICAL_ECONOMIC_EVENTS_OUTPUT_FILE.getAbsolutePath();
            directory = directory.substring(0, directory.length() - "HistoricalEconomicEvents.txt".length());
            frame.printlnInHistoricalEconomicEventsTextArea("   Directory: " + directory);
        } else if (numberOfMonthsOfHistoricalDataToDownload == 0) {
            frame.printlnInHistoricalEconomicEventsTextArea("");
            frame.printlnInHistoricalEconomicEventsTextArea("This file containing historical economic events is located near the present executable:");
            frame.printlnInHistoricalEconomicEventsTextArea("   Name: HistoricalEconomicEvents.txt");
            String directory = Constants.HISTORICAL_ECONOMIC_EVENTS_OUTPUT_FILE.getAbsolutePath();
            directory = directory.substring(0, directory.length() - "HistoricalEconomicEvents.txt".length());
            frame.printlnInHistoricalEconomicEventsTextArea("   Directory: " + directory);
        } else {
            String webPage;
            frame.setHistoricalEconomicEventsResultLabelToProcessing();
            frame.printlnInHistoricalEconomicEventsTextArea("The application is going to complete the file with all events between that date and yesterday (" + sdf.format(yesterday.getTime()) + ").");
            FileWriter historicalEconomicEventsCsvFileWriter = new FileWriter(Constants.HISTORICAL_ECONOMIC_EVENTS_OUTPUT_FILE, true);
            int historicalCounter = 0;
            if (monthOfYesterday == monthOfLastDate && yearOfYesterday == yearOfLastDate) {
                frame.printlnInHistoricalEconomicEventsTextArea("[" + ++historicalCounter + "/" + numberOfMonthsOfHistoricalDataToDownload + "] Download, parse and store Forex Factory economic events for the month " + monthOfYesterday + "/" + yearOfYesterday + "...");
                webPage = DownloadToString.downloadOneMonthToString(yearOfYesterday, monthOfYesterday);
                ParseStringAndSave.parseStringAndSaveToFile(webPage, historicalEconomicEventsCsvFileWriter, yearOfYesterday, monthOfYesterday, dayOfLastDate + 1, dayOfYesterday);
                frame.setProgressBarValue(++progressCounter);
            } else {
                frame.printlnInHistoricalEconomicEventsTextArea("[" + ++historicalCounter + "/" + numberOfMonthsOfHistoricalDataToDownload + "] Download, parse and store Forex Factory economic events for the month " + monthOfLastDate + "/" + yearOfLastDate + "...");
                webPage = DownloadToString.downloadOneMonthToString(yearOfLastDate, monthOfLastDate);
                ParseStringAndSave.parseStringAndSaveToFile(webPage, historicalEconomicEventsCsvFileWriter, yearOfLastDate, monthOfLastDate, dayOfLastDate + 1, 31);
                frame.setProgressBarValue(++progressCounter);
                int currentYear = yearOfLastDate;
                int currentMonth = monthOfLastDate;
                while (monthOfYesterday != currentMonth || yearOfYesterday != currentYear) {
                    if (++currentMonth == 13) {
                        currentMonth = 1;
                        ++currentYear;
                    }
                    frame.printlnInHistoricalEconomicEventsTextArea("[" + ++historicalCounter + "/" + numberOfMonthsOfHistoricalDataToDownload + "] Download, parse and store Forex Factory economic events for the month " + currentMonth + "/" + currentYear + "...");
                    webPage = DownloadToString.downloadOneMonthToString(currentYear, currentMonth);
                    ParseStringAndSave.parseStringAndSaveToFile(webPage, historicalEconomicEventsCsvFileWriter, currentYear, currentMonth, 1, 31);
                    frame.setProgressBarValue(++progressCounter);
                }
                frame.printlnInHistoricalEconomicEventsTextArea("[" + ++historicalCounter + "/" + numberOfMonthsOfHistoricalDataToDownload + "] Download, parse and store Forex Factory economic events for the month " + monthOfYesterday + "/" + yearOfYesterday + "...");
                webPage = DownloadToString.downloadOneMonthToString(yearOfYesterday, monthOfYesterday);
                ParseStringAndSave.parseStringAndSaveToFile(webPage, historicalEconomicEventsCsvFileWriter, yearOfYesterday, monthOfYesterday, 1, dayOfYesterday);
                frame.setProgressBarValue(++progressCounter);
            }
            historicalEconomicEventsCsvFileWriter.close();
            frame.printlnInHistoricalEconomicEventsTextArea("");
            frame.printlnInHistoricalEconomicEventsTextArea("File containing historical economic events is now completed. It is located near the present executable:");
            frame.printlnInHistoricalEconomicEventsTextArea("   Name: HistoricalEconomicEvents.txt");
            String directory = Constants.HISTORICAL_ECONOMIC_EVENTS_OUTPUT_FILE.getAbsolutePath();
            directory = directory.substring(0, directory.length() - "HistoricalEconomicEvents.txt".length());
            frame.printlnInHistoricalEconomicEventsTextArea("   Directory: " + directory);
        }
    }

    public static void main(String[] args) {
        Throwable t;
        GUIFrame frame = new GUIFrame();
        frame.setVisible(true);
        boolean lastStepOK = true;
        int nbOfMonthsForFutureEconomicEvents = Main.step1_nbMonthsToDownloadForFutureEconomicEvents();
        int nbOfMonthsForHistoricalEconomicEvents = 0;
        try {
            nbOfMonthsForHistoricalEconomicEvents = Main.step2_nbMonthsToDownloadForHistoricalEconomicEvents(frame);
        }
        catch (Exception ex) {
            lastStepOK = false;
            frame.setResultLabelToProblem();
            frame.enableCloseButton(false);
            frame.printExceptionInHistoricalEconomicEventsTextArea(ex);
            t = ex;
            while (t.getCause() != null) {
                t = t.getCause();
                frame.printExceptionInHistoricalEconomicEventsTextArea(t);
            }
        }
        frame.setProgressBarMaximum(nbOfMonthsForFutureEconomicEvents + nbOfMonthsForHistoricalEconomicEvents);
        if (lastStepOK) {
            try {
                Main.step3_proceedForFutureEconomicEvents(frame);
                frame.setFutureEconomicEventsResultLabelToOK();
            }
            catch (Exception ex) {
                lastStepOK = false;
                frame.setFutureEconomicEventsResultLabelToProblem();
                frame.setResultLabelToProblem();
                frame.enableCloseButton(false);
                frame.printExceptionInFutureEconomicEventsTextArea(ex);
                t = ex;
                while (t.getCause() != null) {
                    t = t.getCause();
                    frame.printExceptionInFutureEconomicEventsTextArea(t);
                }
            }
        }
        if (lastStepOK) {
            try {
                Main.step4_proceedForHistoricalEconomicEvents(frame);
                frame.setHistoricalEconomicEventsResultLabelToOK();
                frame.setResultLabelToOK();
                frame.enableCloseButton(true);
            }
            catch (Exception ex) {
                frame.setHistoricalEconomicEventsResultLabelToProblem();
                frame.setResultLabelToProblem();
                frame.enableCloseButton(false);
                frame.printExceptionInHistoricalEconomicEventsTextArea(ex);
                t = ex;
                while (t.getCause() != null) {
                    t = t.getCause();
                    frame.printExceptionInHistoricalEconomicEventsTextArea(t);
                }
            }
        }
    }
}

