/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParseStringAndSave {
    private static final int HOUR_OFFSET = 0;
    private static final Pattern DATE_PATTERN = Pattern.compile(">([\\w\\s]*)</span>");
    private static final Pattern HOUR_PATTERN_1 = Pattern.compile("td class=\\\"time\\\">([\\w\\s:-]*)</td>");
    private static final Pattern HOUR_PATTERN_2 = Pattern.compile("a><span class=\\\"upnext\\\">([\\w\\s:-]*)</span>");
    private static final Pattern COUNTRY_PATTERN = Pattern.compile(">([\\w\\s]*)");
    private static final Pattern EVENT_PATTERN = Pattern.compile(">([\\w\\s\\.\\*&;(),/-]*)</span>");
    private static final DateFormat DATE_FORMAT_IN = new SimpleDateFormat("yyyy MMM d", Locale.ENGLISH);
    private static final DateFormat DATE_FORMAT_OUT = new SimpleDateFormat("MMdd");
    private static final DateFormat HOUR_FORMAT_IN = new SimpleDateFormat("h:mma");
    private static final DateFormat HOUR_FORMAT_OUT = new SimpleDateFormat("HHmm");
    private static String currentDate;

    private static boolean containsDayOfWeek(String line) {
        return line.contains(">Sun<") || line.contains(">Mon<") || line.contains(">Tue<") || line.contains(">Wed<") || line.contains(">Thu<") || line.contains(">Fri<") || line.contains(">Sat<");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void parseStringAndSaveToFile(String inputString, FileWriter eventsCsvFileWriter, int yearOfFile, int monthOfFile, int firstDayOfMonthToBeConsidered, int lastDayOfMonthToBeConsidered) throws IOException, Exception {
        String[] elements = inputString.split("</td>");
        String hourString = "";
        int month = 0;
        int day = 0;
        Date MonthAndDayDate = new Date();
        GregorianCalendar monthAndDayGc = new GregorianCalendar();
        GregorianCalendar hourGc = new GregorianCalendar();
        GregorianCalendar fullDateGc = new GregorianCalendar();
        int index = 0;
        while (index < elements.length) {
            String event;
            String country;
            boolean noSpecificTime;
            Matcher m;
            if (!elements[index].contains("eventid")) {
                ++index;
                continue;
            }
            String line = elements[index];
            if (ParseStringAndSave.containsDayOfWeek(line)) {
                m = DATE_PATTERN.matcher(line);
                if (!m.find()) throw new ParseException("Problem for identification of date in: " + line, 0);
                String dateString = m.group(1);
                MonthAndDayDate = DATE_FORMAT_IN.parse(yearOfFile + " " + dateString);
                monthAndDayGc.setTime(MonthAndDayDate);
                month = monthAndDayGc.get(2);
                day = monthAndDayGc.get(5);
                currentDate = "" + (yearOfFile - 1900) + DATE_FORMAT_OUT.format(MonthAndDayDate);
            }
            line = elements[++index] + "</td>";
            Matcher m1 = HOUR_PATTERN_1.matcher(line);
            Matcher m2 = HOUR_PATTERN_2.matcher(line);
            boolean m1Found = m1.find();
            boolean m2Found = m2.find();
            if (!m1Found && !m2Found) throw new ParseException("Problem for identification of hour in: " + line, 0);
            if (m1Found && m2Found) {
                throw new ParseException("Hour has been idenfied in both normal [* " + m1.group(1) + " *] and upnext [* " + m2.group(1) + " *] patterns in: " + line, 0);
            }
            String hourString0 = m1Found ? m1.group(1) : m2.group(1);
            boolean emptyTime = "".equals(hourString0);
            boolean bl = noSpecificTime = !emptyTime && !hourString0.contains("am") && !hourString0.contains("pm");
            if (!emptyTime) {
                hourString = hourString0;
                if (!noSpecificTime) {
                    Date hourDate = HOUR_FORMAT_IN.parse(hourString);
                    hourGc.setTime(hourDate);
                    int hour = hourGc.get(11);
                    int minute = hourGc.get(12);
                    fullDateGc.set(yearOfFile, month, day, hour, minute);
                    fullDateGc.add(11, 0);
                    currentDate = "" + (yearOfFile - 1900) + DATE_FORMAT_OUT.format(fullDateGc.getTime());
                    hourString = HOUR_FORMAT_OUT.format(fullDateGc.getTime());
                } else {
                    currentDate = "" + (yearOfFile - 1900) + DATE_FORMAT_OUT.format(MonthAndDayDate);
                    continue;
                }
            }
            m = COUNTRY_PATTERN.matcher(elements[++index]);
            if (!m.find()) {
                country = "???";
                throw new ParseException("Problem for identification of country in: " + elements[index], 0);
            }
            country = m.group(1);
            int impactDigit = elements[++index].contains("High") ? 3 : (elements[index].contains("Medium") ? 2 : (elements[index].contains("Low") ? 1 : 0));
            m = EVENT_PATTERN.matcher(elements[++index]);
            if (!m.find()) {
                event = "???";
                throw new ParseException("Problem in identification of event title in: " + elements[index], 0);
            }
            event = m.group(1);
            event = event.replace(",", " -");
            event = event.replace("&amp;", "&");
            if (noSpecificTime) continue;
            String outputLine = currentDate + "," + hourString + "," + impactDigit + "," + country + "," + event + System.getProperty("line.separator");
            int dayOfMonth = Integer.parseInt(currentDate.substring(currentDate.length() - 2));
            if (firstDayOfMonthToBeConsidered > dayOfMonth || dayOfMonth > lastDayOfMonthToBeConsidered) continue;
            eventsCsvFileWriter.write(outputLine, 0, outputLine.length());
        }
    }
}

